<?php

$locale = array(
	'AE' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'required' => false,
		),
	),
	'AF' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'AL' => array(
		'state' => array(
			'label' => 'County',
		),
	),
	'AO' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'label' => 'Province',
		),
	),
	'AT' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'AU' => array(
		'city'     => array(
			'label' => 'Suburb',
		),
		'postcode' => array(
			'label' => 'Postcode',
		),
		'state'    => array(
			'label' => 'State',
		),
	),
	'AX' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'BA' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'label'    => 'Canton',
			'required' => false,
			'hidden'   => true,
		),
	),
	'BD' => array(
		'postcode' => array(
			'required' => false,
		),
		'state'    => array(
			'label' => 'District',
		),
	),
	'BE' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'BG' => array(
		'state' => array(
			'required' => false,
		),
	),
	'BH' => array(
		'postcode' => array(
			'required' => false,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'BI' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'BO' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'label' => 'Department',
		),
	),
	'BS' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'BZ' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'required' => false,
		),
	),
	'CA' => array(
		'postcode' => array(
			'label' => 'Postal code',
		),
		'state'    => array(
			'label' => 'Province',
		),
	),
	'CH' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'label'    => 'Canton',
			'required' => false,
		),
	),
	'CL' => array(
		'city'     => array(
			'required' => true,
		),
		'postcode' => array(
			'required' => false,
			// Hidden for stores within Chile. @see https://github.com/woocommerce/woocommerce/issues/36546.
			'hidden'   => true
		),
		'state'    => array(
			'label' => 'Region',
		),
	),
	'CN' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'CO' => array(
		'postcode' => array(
			'required' => false,
		),
		'state'    => array(
			'label' => 'Department',
		),
	),
	'CR' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'CW' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'required' => false,
		),
	),
	'CY' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'CZ' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'DE' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
		),
	),
	'DK' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'DO' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'EC' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'EE' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'ET' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'FI' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'FR' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'GG' => array(
		'state' => array(
			'required' => false,
			'label'    => 'Parish',
		),
	),
	'GH' => array(
		'postcode' => array(
			'required' => false,
		),
		'state'    => array(
			'label' => 'Region',
		),
	),
	'GP' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'GF' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'GR' => array(
		'state' => array(
			'required' => false,
		),
	),
	'GT' => array(
		'postcode' => array(
			'required' => false,
		),
		'state'    => array(
			'label' => 'Department',
		),
	),
	'HK' => array(
		'postcode' => array(
			'required' => false,
		),
		'city'     => array(
			'label' => 'Town / District',
		),
		'state'    => array(
			'label' => 'Region',
		),
	),
	'HN' => array(
		'state' => array(
			'label' => 'Department',
		),
	),
	'HU' => array(
		'last_name'  => array(
			'class'    => array( 'form-row-first' ),
			'priority' => 10,
		),
		'first_name' => array(
			'class'    => array( 'form-row-last' ),
			'priority' => 20,
		),
		'postcode'   => array(
			'class'    => array( 'form-row-first', 'address-field' ),
			'priority' => 65,
		),
		'city'       => array(
			'class' => array( 'form-row-last', 'address-field' ),
		),
		'address_1'  => array(
			'priority' => 71,
		),
		'address_2'  => array(
			'priority' => 72,
		),
		'state'      => array(
			'label'    => 'County',
			'required' => false,
		),
	),
	'ID' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'IE' => array(
		'postcode' => array(
			'required' => false,
			'label'    => 'Eircode',
		),
		'state'    => array(
			'label' => 'County',
		),
	),
	'IS' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'IL' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'IM' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'IN' => array(
		'postcode' => array(
			'label' => 'PIN Code',
		),
		'state'    => array(
			'label' => 'State',
		),
	),
	'IR' => array(
		'state'     => array(
			'priority' => 50,
		),
		'city'      => array(
			'priority' => 60,
		),
		'address_1' => array(
			'priority' => 70,
		),
		'address_2' => array(
			'priority' => 80,
		),
	),
	'IT' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => true,
			'label'    => 'Province',
		),
	),
	'JM' => array(
		'city'     => array(
			'label' => 'Town / City / Post Office',
		),
		'postcode' => array(
			'required' => false,
			'label'    => 'Postal Code',
		),
		'state'    => array(
			'required' => true,
			'label'    => 'Parish',
		),
	),
	'JP' => array(
		'last_name'  => array(
			'class'    => array( 'form-row-first' ),
			'priority' => 10,
		),
		'first_name' => array(
			'class'    => array( 'form-row-last' ),
			'priority' => 20,
		),
		'postcode'   => array(
			'class'    => array( 'form-row-first', 'address-field' ),
			'priority' => 65,
		),
		'state'      => array(
			'label'    => 'Prefecture',
			'class'    => array( 'form-row-last', 'address-field' ),
			'priority' => 66,
		),
		'city'       => array(
			'priority' => 67,
		),
		'address_1'  => array(
			'priority' => 68,
		),
		'address_2'  => array(
			'priority' => 69,
		),
	),
	'KN' => array(
		'postcode' => array(
			'required' => false,
			'label'    => 'Postal code',
		),
		'state'    => array(
			'required' => true,
			'label'    => 'Parish',
		),
	),
	'KR' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'KW' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'LV' => array(
		'state' => array(
			'label'    => 'Municipality',
			'required' => false,
		),
	),
	'LB' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'MF' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'MQ' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'MT' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'MZ' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'label' => 'Province',
		),
	),
	'NI' => array(
		'state' => array(
			'label' => 'Department',
		),
	),
	'NL' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'NG' => array(
		'postcode' => array(
			'label'    => 'Postcode',
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'label' => 'State',
		),
	),
	'NZ' => array(
		'postcode' => array(
			'label' => 'Postcode',
		),
		'state'    => array(
			'required' => false,
			'label'    => 'Region',
		),
	),
	'NO' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'NP' => array(
		'state'    => array(
			'label' => 'State / Zone',
		),
		'postcode' => array(
			'required' => false,
		),
	),
	'PA' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'PL' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'PR' => array(
		'city'  => array(
			'label' => 'Municipality',
		),
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'PT' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'PY' => array(
		'state' => array(
			'label' => 'Department',
		),
	),
	'RE' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'RO' => array(
		'state' => array(
			'label'    => 'County',
			'required' => true,
		),
	),
	'RS' => array(
		'city'     => array(
			'required' => true,
		),
		'postcode' => array(
			'required' => true,
		),
		'state'    => array(
			'label'    => 'District',
			'required' => false,
		),
	),
	'RW' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'SG' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
		'city'  => array(
			'required' => false,
		),
	),
	'SK' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'SI' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'SR' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'SV' => array(
		'state' => array(
			'label' => 'Department',
		),
	),
	'ES' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'label' => 'Province',
		),
	),
	'LI' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'LK' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'LU' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'MD' => array(
		'state' => array(
			'label' => 'Municipality / District',
		),
	),
	'SE' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'TR' => array(
		'postcode' => array(
			'priority' => 65,
		),
		'state'    => array(
			'label' => 'Province',
		),
	),
	'UG' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'city'     => array(
			'label'    => 'Town / Village',
			'required' => true,
		),
		'state'    => array(
			'label'    => 'District',
			'required' => true,
		),
	),
	'US' => array(
		'postcode' => array(
			'label' => 'ZIP Code',
		),
		'state'    => array(
			'label' => 'State',
		),
	),
	'UY' => array(
		'state' => array(
			'label' => 'Department',
		),
	),
	'GB' => array(
		'postcode' => array(
			'label' => 'Postcode',
		),
		'state'    => array(
			'label'    => 'County',
			'required' => false,
		),
	),
	'ST' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
		'state'    => array(
			'label' => 'District',
		),
	),
	'VN' => array(
		'state'     => array(
			'required' => false,
			'hidden'   => true,
		),
		'postcode'  => array(
			'priority' => 65,
			'required' => false,
			'hidden'   => false,
		),
		'address_2' => array(
			'required' => false,
			'hidden'   => false,
		),
	),
	'WS' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'YT' => array(
		'state' => array(
			'required' => false,
			'hidden'   => true,
		),
	),
	'ZA' => array(
		'state' => array(
			'label' => 'Province',
		),
	),
	'ZW' => array(
		'postcode' => array(
			'required' => false,
			'hidden'   => true,
		),
	)
);

return apply_filters( 'xoo_aff_fields_country_locale', $locale );

?>