<?php
namespace Wtpdf\Ubl\Handler;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( !class_exists( '\\Wtpdf\\Ubl\\Handler\\XmlFileHandler' )) {

class XmlFileHandler{

    public function __construct() {
    }

    public function generate_xml( $xml_content, $basedir, $name, $action = '', $order = null ) {
        $upload_loc = \Wf_Woocommerce_Packing_List::get_temp_dir();
        $upload_dir = $upload_loc['path'];
        $upload_url = $upload_loc['url'];

        if( !is_dir( $upload_dir ) ) {
            wp_mkdir_p( $upload_dir );
        }

        $upload_dir=$upload_dir.'/'.$basedir.'/ubl';
        $upload_url=$upload_url.'/'.$basedir.'/ubl';
        if( !is_dir( $upload_dir ) ) {
            wp_mkdir_p( $upload_dir );
        }

        if( is_dir( $upload_dir ) ) {
            $file_path = $upload_dir . '/'.$name.'.xml';
            $file_url = $upload_url . '/'.$name.'.xml';
           
            // Extract directory path from file path in case $name contains subdirectories
            $file_dir = dirname( $file_path );
            if( !is_dir( $file_dir ) ) {
                wp_mkdir_p( $file_dir );
            }
           
            // Write the XML content to the file locally
            file_put_contents($file_path, $xml_content);
            
            if( "download" === $action ) {  
                 // Set the appropriate headers to force the browser to download the file.
                header('Content-Type: application/xml');                          // Set the content type to XML.
                header('Content-Disposition: attachment; filename="' . $name . '.xml"');  // Set the content disposition to 'attachment' to force download.

                // Output the XML content (this will be downloaded as a file by the browser).
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Trusted XML content generated by UBL module
                echo $xml_content;
            } else {
                // email attachment.
                return $file_path;
            }
        }
    }
}

}