<?php 
// Template Name: About
get_header('custom');
$query = get_queried_object();
$sec_one = get_post(93);

$sec_two = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'ASC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'our-promise'
		)
	)
]);

$testi = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'DESC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'testimonial'
		)
	)
]);


?>

<div class="container">
	<div class="row">
		<div class="col-lg-12">
			<div class="banner">
				<h1><?php echo $query->post_title;?></h1>
			</div>
		</div>
	</div>
</div>


<section class="abt-one">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1><?php echo $sec_one->post_title;?></h1>
				<p class="headline"><?php echo $sec_one->post_excerpt;?></p>
			</div>
			<div class="col-lg-5">
				<img src="<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($sec_one->ID),'full')[0];?>" class="img-responsive">
			</div>
			<div class="col-lg-7">
				<?php echo wpautop($sec_one->post_content);?>
			</div>
		</div>
	</div>
</section>

<section class="abt-two">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>our promise</h1>
			</div>
			<?php 
			foreach($sec_two as $post){
				$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
			
			?>
			<div class="col-lg-4">
				<div class="wrapper">
					<img src="<?php echo $image[0];?>" class="img-responsive">
					<h3><?php echo $post->post_title;?></h3>
					<p><?php echo $post->post_content;?></p>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>

<section class="testi">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h5>testimonial</h5>
				<h1>what our clients says about us</h1>
				<div class="wrapper">
					<?php 
					foreach($testi as $posts){
						$image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
					
					?>
					<div class="content">
						<img src="<?php echo $image[0];?>" class="img-responsive">
						<div class="title"><?php echo $posts->post_title;?></div>
						<p><?php echo $posts->post_content;?></p>
					</div>
					<?php } ?>
					
				</div>
			</div>
		</div>
	</div>
</section>


<?php get_footer('custom');?>