<?php
// Template Name: Laundry Calculator
get_header('custom');

$prods = get_terms([
    'taxonomy'   => 'product_cat',
    'hide_empty' => false,
    'parent'     => 0,
    'exclude'    => [15]
]);
?>
<div class="banner" style="background-image: url('<?php echo get_template_directory_uri().
'/assets/images/planchado-lavanderia_137573-984.webp';?>');">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>Calculator</h1>
				<p>Get all your Regular Wear items & Linens-Washed, Dried & Steam Ironed / Neatly folded and stacked in a weatherproof box.</p>
			</div>
		</div>
	</div>
</div>
<section class="calculator">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="products_list_container">
                    <?php 
                    // Get all product IDs currently in the cart to handle the "checked" state
                    $cart_product_ids = [];
                    if ( WC()->cart ) {
                        foreach ( WC()->cart->get_cart() as $cart_item ) {
                            $cart_product_ids[] = $cart_item['product_id'];
                        }
                    }

                    foreach($prods as $cat): 
                        $posts = get_posts([
                            'post_type' => 'product',
                            'post_status' => 'publish',
                            'posts_per_page' => -1,
                            'tax_query' => [['taxonomy' => $cat->taxonomy, 'field' => 'id', 'terms' => $cat->term_id]]
                        ]);
                    ?>
                        <h5 style="margin-top: 20px; font-weight: bold; border-left: 4px solid #28a745; padding-left: 10px;">
                            <?php echo esc_html($cat->name); ?>
                        </h5>
                        <ul class="list-inline laundry-list">
                            <?php foreach($posts as $post): 
                                $icon = get_field('icon', $post->ID);
                                // Check if this specific product ID is in our cart array
                                $is_selected = in_array($post->ID, $cart_product_ids);
                            ?>
                                <li class="product-item <?php echo $is_selected ? 'selected-item' : ''; ?>" data-parent="<?php echo $post->ID; ?>">
                                    <div class="types">
                                        <div class="product-box <?php echo $is_selected ? 'checked' : ''; ?>">
                                            <i class="fa <?php echo $is_selected ? 'fa-check' : ''; ?>"></i>
                                        </div>
                                        <?php if($icon): ?>
                                            <img src="<?php echo esc_url($icon); ?>" class="img-responsive" />
                                        <?php endif; ?>
                                        <h4><?php echo esc_html($post->post_title); ?></h4>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endforeach; ?>
                </div>

                <div class="calculator-item-details" style="display:none; margin-top: 30px;">
                    <div class="cid-head" style="display: flex; justify-content: space-between; background: #f4f4f4; padding: 10px; font-weight: bold; border-radius: 5px;">
                        <span style="flex:1;">Title</span>
                        <span style="flex:1;">Quantity</span>
                        <span style="flex:2;">Choose Service</span>
                        <span style="flex:0.2;">Action</span>
                    </div>
                </div>
                <ul class="calculator-selected-item-list" style="padding:0; list-style:none;"></ul>
            </div>

            <div class="col-md-4">
                <div class="calculator-container" style="position: sticky; top: 20px; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.05);">
                    <div class="calculator-summary-content">
                         <?php echo generate_calculator_cart_html(); ?>
                    </div>
                    
                    <div style="margin-top: 20px; padding-top: 15px; border-top: 1px dashed #ccc;">
                        <p style="font-size: 13px; color: #666; font-style: italic;">
                            <i class="fa fa-truck"></i> Free Laundry Pickup & Delivery on Orders of Rs.700 or More.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer('custom'); ?>