<?php
//Template Name: Cleaning
get_header('custom');
$packages = get_posts([
   'post_status'    => 'publish',
   'order'          => 'ASC',
   'tax_query'  => array(
           array(
                   'taxonomy'   => 'category',
                    'field'     => 'slug',
                    'terms'     => 'packages'
           )
   )
]);
$cleaning = get_posts([
   'post_status'    => 'publish',
   'order'          => "ASC",
   'posts_per_page' => -1,
   'tax_query'  => array(
           array(
                   'taxonomy'   => 'category',
                    'field'     => 'slug',
                    'terms'     => 'cleaning'
           )
   )
]);
?>
<div class="cleaning-slider">
    <div class="mainwrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="content">
                        <h1>Are you looking for a Cleaning?</h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section class="clean-one">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <ul class="list-inline">
                    <li><svg class="svg-inline--fa fa-house" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="house" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" data-fa-i2svg=""><path fill="currentColor" d="M575.8 255.5C575.8 273.5 560.8 287.6 543.8 287.6H511.8L512.5 447.7C512.5 450.5 512.3 453.1 512 455.8V472C512 494.1 494.1 512 472 512H456C454.9 512 453.8 511.1 452.7 511.9C451.3 511.1 449.9 512 448.5 512H392C369.9 512 352 494.1 352 472V384C352 366.3 337.7 352 320 352H256C238.3 352 224 366.3 224 384V472C224 494.1 206.1 512 184 512H128.1C126.6 512 125.1 511.9 123.6 511.8C122.4 511.9 121.2 512 120 512H104C81.91 512 64 494.1 64 472V360C64 359.1 64.03 358.1 64.09 357.2V287.6H32.05C14.02 287.6 0 273.5 0 255.5C0 246.5 3.004 238.5 10.01 231.5L266.4 8.016C273.4 1.002 281.4 0 288.4 0C295.4 0 303.4 2.004 309.5 7.014L564.8 231.5C572.8 238.5 576.9 246.5 575.8 255.5L575.8 255.5z"></path></svg><!-- <i class="fa-solid fa-house"></i> Font Awesome fontawesome.com -->
                        <h3>Regular Domestic Cleaning</h3>
                    </li>
                    <li><svg class="svg-inline--fa fa-building" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="building" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" data-fa-i2svg=""><path fill="currentColor" d="M336 0C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H240V432C240 405.5 218.5 384 192 384C165.5 384 144 405.5 144 432V512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336zM64 272C64 280.8 71.16 288 80 288H112C120.8 288 128 280.8 128 272V240C128 231.2 120.8 224 112 224H80C71.16 224 64 231.2 64 240V272zM176 224C167.2 224 160 231.2 160 240V272C160 280.8 167.2 288 176 288H208C216.8 288 224 280.8 224 272V240C224 231.2 216.8 224 208 224H176zM256 272C256 280.8 263.2 288 272 288H304C312.8 288 320 280.8 320 272V240C320 231.2 312.8 224 304 224H272C263.2 224 256 231.2 256 240V272zM80 96C71.16 96 64 103.2 64 112V144C64 152.8 71.16 160 80 160H112C120.8 160 128 152.8 128 144V112C128 103.2 120.8 96 112 96H80zM160 144C160 152.8 167.2 160 176 160H208C216.8 160 224 152.8 224 144V112C224 103.2 216.8 96 208 96H176C167.2 96 160 103.2 160 112V144zM272 96C263.2 96 256 103.2 256 112V144C256 152.8 263.2 160 272 160H304C312.8 160 320 152.8 320 144V112C320 103.2 312.8 96 304 96H272z"></path></svg><!-- <i class="fa-solid fa-building"></i> Font Awesome fontawesome.com -->
                        <h3>Office Cleaning</h3>
                    </li>
                    <li><svg class="svg-inline--fa fa-leaf" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="leaf" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" data-fa-i2svg=""><path fill="currentColor" d="M512 165.4c0 127.9-70.05 235.3-175.3 270.1c-20.04 7.938-41.83 12.46-64.69 12.46c-64.9 0-125.2-36.51-155.7-94.47c-54.13 49.93-68.71 107-68.96 108.1C44.72 472.6 34.87 480 24.02 480c-1.844 0-3.727-.2187-5.602-.6562c-12.89-3.098-20.84-16.08-17.75-28.96c9.598-39.5 90.47-226.4 335.3-226.4C344.8 224 352 216.8 352 208S344.8 192 336 192C228.6 192 151 226.6 96.29 267.6c.1934-10.82 1.242-21.84 3.535-33.05c13.47-65.81 66.04-119 131.4-134.2c28.33-6.562 55.68-6.013 80.93-.0054c56 13.32 118.2-7.412 149.3-61.24c5.664-9.828 20.02-9.516 24.66 .8282C502.7 76.76 512 121.9 512 165.4z"></path></svg><!-- <i class="fa-solid fa-leaf"></i> Font Awesome fontawesome.com -->
                        <h3>One-off/Spring Cleaning</h3>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="clean-two">
    <div class="mainwrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h1>Other Services</h1>
                    <p>Look up our services and choose the one that suits your needs. We've got you covered!</p>
                </div>
                <?php 
                foreach($cleaning as $posts){ 
                    $image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
                ?>
                <div class="col-lg-4">
                    <div class="wrapper">
                        <img src="<?php echo $image[0]; ?>" class="img-responsive" alt="">
                        <div class="content">
                            <?php echo get_field('fonts',$posts->ID);?>
                            <h4><?php echo $posts->post_title;?></h4>
                            <p><?php echo $posts->post_content;?></p>
                        </div>
                        <a href="#" data-toggle="modal" data-target="#quotepopup" data-title="<?php echo $posts->post_title;?>">Get Quote</a>
                    </div>
                </div>
                <?php } ?>
                

            </div>
        </div>
    </div>
</section>

<section class="clean-three">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1>Level of Services</h1>
                <?php
                    foreach($packages as $package){
                        $image = wp_get_attachment_image_src(get_post_thumbnail_id($package->ID),'full');
                        $gal = get_field('icons',$package->ID);
                ?>
                <div class="package">
                    <img src="<?php echo $image[0];?>" class="img-responsive">
                    <h3><?php echo $package->post_title;?></h3>
                    <?php echo $package->post_content;?>
                    <ul class="list-inline">
                        <?php 
                            foreach($gal as $icons){
                            ?>
                            <li>
                                <img src="<?php echo $icons['full_image_url'];?>" class="img-responsive" alt="">
                                <h5><?php echo $icons['caption'];?></h5>
                            </li>    
                        <?php } ?>
                    </ul>
                    <button class="btn-terms" 
                            data-toggle="modal" 
                            data-target="#termsModal"
                            data-title="<?php echo $package->post_title; ?> - Terms"
                            data-excerpt="<?php echo $package->post_excerpt; ?>">
                        Terms & Conditions
                    </button>
                    <a href="#" data-toggle="modal" data-target="#quotepopup" data-title="<?php echo $package->post_title;?>">Book Now</a>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<!-- Modal -->
<div class="modal fade" id="quotepopup" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Book Now</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form">
                    <?php echo do_shortcode('[wpforms id="347"]');?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="termsModal" tabindex="-1" role="dialog" aria-labelledby="termsModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content" style="border-radius: 15px; overflow: hidden;">
      <div class="modal-header" style="background-color: #79b927; color: white;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 1;"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="termsModalLabel" style="font-weight: bold;">Service Terms</h4>
      </div>
      <div class="modal-body" id="termsBody" style="padding: 30px; font-size: 15px; line-height: 1.6; color: #444;">
        </div>
    </div>
  </div>
</div>

<?php get_footer('custom');?>
