<?php 
// Template Name: Home
get_header('custom');
global $count;
$slider = get_posts([
	'posts_per_page'	=> -1,
	'post_status'		=> 'publish',
	'order'				=> 'ASC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'slider'
		)
	)
]);

$cats = get_terms([
	'taxonomy'	=> 'product_cat',
	'parent'	=> 0,
	'hide_empty'=> false,
	'exclude'	=> array(15,35),
	'orderby'	=> 'id',
	'order'		=> 'ASC'
]);
$about = get_post(35);
$abt_gal = get_field('about_gal',$about->ID);

$prods = get_posts([
	'post_type'		=> 'product',
	'posts_per_page'	=> 10,
	'post_status'		=> 'publish',
	'order'				=> 'ASC'
]);

$works = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'ASC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'how-it-works'
		)
	)
]);

$testi = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'DESC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'testimonial'
		)
	)
]);
$ticker = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'ASC',
	'include'		=> array(352,357,359)
]);
$package = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'ASC',
	'include'		=> array(372,374,376)
]);
?>
<div class="hero-img">
	<div class="wrapper">
		<?php 
		foreach($slider as $slides ){
			$image = wp_get_attachment_image_src(get_post_thumbnail_id($slides->ID),'full');
		
		?>
		<div class="wrapup">
			<img src="<?php echo $image[0];?>" class="img-responsive" alt="">
			<div class="content">
				<h4><?php echo $slides->post_title;?></h4>
				<?php echo wpautop($slides->post_content);?>
			</div>
		</div>
		<?php } ?>
	</div>
</div>

<section class="ticker reveal from-bottom">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<ul class="list-inline">
					<?php 
					foreach($ticker as $posts){
						$image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
					
					?>
					<li>
						<img src="<?php echo $image[0];?>" class="img-responsive" alt="">
						<div class="content">
							<h3><?php echo $posts->post_title;?></h3>
							<?php echo wpautop($posts->post_content);?>
						</div>
					</li>
					<?php } ?>
				</ul>
			</div>
		</div>
	</div>
</section>

<section class="sec-one reveal from-bottom">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h4>our services</h4>
				<h1>save time using <br>our laundary services</h1>
				<ul class="reveal from-right">
				<?php 
				foreach($cats as $terms){
					$thumbnail_id = get_term_meta( $terms->term_id, 'thumbnail_id', true ); 
					// get the image URL
					$image = wp_get_attachment_url( $thumbnail_id ); 

				?>
				<li>
					<div class="wrapper">
						<img src="<?php echo $image;?>" class="img-responsive">
						<h3><?php echo $terms->name;?></h3>
						<p><?php echo $terms->description;?></p>
						<a href="<?php echo get_term_link($terms->term_id);?>">
							<i class="fa fa-angle-right"></i>
						</a>
					</div>
				</li>
				<?php } ?>
			</ul>	
			</div>
		</div>
	</div>
</section>

<section class="sec-two">
	<div class="container">
		<div class="row">
			<div class="col-lg-6 reveal from-left">
				<h5><?php echo $about->post_title;?></h5>
				<?php echo $about->post_content;?>
			</div>
			<div class="col-lg-6 reveal from-right">
				<?php 
				foreach($abt_gal as $gal){

				?>
				<div class="image">
					<img src="<?php echo $gal['full_image_url'];?>" class="img-responsive">
				</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>

<section class="sec-three reveal from-top">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>price list</h1>
				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
				quis nostrud exercitation ullamco laboris nisi ut.</p>
				<ul class="list-inline">
					<?php 
					foreach($prods as $post){
						$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
						$product = new WC_Product($post->ID);
					?>
					<li>
						<img src="<?php echo $image[0];?>" class="img-responsive">
						<p><?php echo $post->post_title;?></p>
						<p class="price">Rs <?php echo $product->get_regular_price();?></p>
					</li>
					<?php } ?>
					
				</ul>
				<a href="<?php echo get_permalink(220);?>">book now</a>
			</div>
		</div>
	</div>
</section>

<section class="sec-four reveal from-top">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>how it works</h1>
			</div>
			<div class="wrapper reveal from-bottom">
				<?php 
				foreach($works as $posts){
					$image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
					$count ++;
				?>
				<div class="col-lg-3">
					<div class="wrapup">
						<img src="<?php echo $image[0];?>" class="img-responsive" alt="">
						<div class="circle"><?php echo $count;?></div>
						<h4><?php echo $posts->post_title;?></h4>
						<p><?php echo $posts->post_content;?></p>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>

<div class="home-package">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h4>what we offer</h4>
				<h1>price packages</h1>
				<p>Our prices are simple and affordable which are easy on pocket in comparison with the high street prices</p>			
				<?php 
				foreach($package as $posts){
					$image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
				?>
				<div class="wrapper">
					<div class="icon">
						<img src="<?php echo $image[0];?>" class="img-responsive" alt="">
					</div>
					<h3><?php echo $posts->post_title;?></h3>
					<h4><?php echo $posts->post_excerpt;?></h4>
					<?php echo $posts->post_content;?>
					<button>Order Now</button>
				</div>
				<?php } ?>
				
				
			</div>
		</div>
	</div>
</div>

<section class="testi">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h4>testimonial</h4>
				<h1>what our clients says about us</h1>
				<div class="wrapper">
					<?php 
					foreach($testi as $posts){
						$image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
					
					?>
					<div class="content">
						<img src="<?php echo $image[0];?>" class="img-responsive">
						<div class="title"><?php echo $posts->post_title;?></div>
						<p><?php echo $posts->post_content;?></p>
					</div>
					<?php } ?>
					
				</div>
			</div>
		</div>
	</div>
</section>

<!-- <section class="sec-app">
	<div class="container">
		<div class="row">
			<div class="col-lg-6">
				<h5>mobile app</h5>
				<h1>make your order online from any where</h1>
				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse
				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non
				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
			</div>
			<div class="col-lg-6">
				<img src="<?php echo get_template_directory_uri().'/assets/images/s89-pom-0083-03-mockup_2.png';?>" class="img-responsive">
			</div>
		</div>
	</div>
</section> -->

<?php get_footer('custom');?>