<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
</head>

<body>
<?php wp_body_open(); ?>
<div class="topnav">
	<div class="container">
		<div class="row">
			<div class="col-lg-6">
				<ul class="list-inline" style="margin-top:5px;">
					<li>
						<i class="fa fa-phone"></i>	+923001234567
					</li>
					<li>
						<i class="fa fa-envelope"></i> info@domain.com
					</li>
				</ul>
			</div>
			<div class="col-lg-6">
				<ul class="list-inline right">
					<li>
						<a href="">
							<i class="fa fa-facebook"></i>
						</a>
					</li>
					<li>
						<a href="">
							<i class="fa fa-linkedin"></i>
						</a>
					</li>
					<li>
						<a href="">
							<i class="fa fa-instagram"></i>
						</a>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>
<div class="mainnav">
	<div class="container">
		<div class="row">
			<div class="col-lg-3">
				<div class="logo">
					<a href="<?php echo home_url('/');?>">
						<img src="<?php echo get_template_directory_uri().'/assets/images/logo.png';?>" class="img-responsive">
					</a>
				</div>
			</div>
			<div class="col-lg-7">
				<?php
                    wp_nav_menu( array(
                        'menu'              => 'main_menu',
                        'depth'             => 2,
                        'menu_class'        => 'list-inline menus',
                        'fallback_cb'       => false,
                        'walker'            => new WP_Bootstrap_Navwalker(),
                    ) );
                    ?>
			</div>
			<div class="col-lg-2">
				<ul class="list-inline logins">
					<li>
						<?php 
						if(is_user_logged_in() || is_checkout()){ 
						?>
						<a href="<?php echo get_permalink(9);?>">
							<img src="<?php echo get_template_directory_uri().'/assets/images/icons8-user-32.png';?>" class="img-responsive" alt="">
						</a>
						<?php }else{ ?>
						<a href="#" class="xoo-el-login-tgr">
							<img src="<?php echo get_template_directory_uri().'/assets/images/icons8-user-32.png';?>" class="img-responsive" alt="">
						</a>
						<?php } ?>
					</li>
					<li>	
						<a href="<?php echo get_permalink(7);?>">
							<img src="<?php echo get_template_directory_uri().'/assets/images/icons8-shopping-bag-32.png';?>" class="img-responsive">
						</a>
						<a href="<?php echo get_permalink(7);?>" class="cart-content">0</a>
					</li>
				</ul>
			</div>
			<!-- <div class="col-lg-2">
				<button>Book Now</button>
			</div> -->
		</div>
	</div>
</div>
