<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'custom' );
$query = get_queried_object();

$serv = get_posts([
	'post_status'	=> 'publish',
	'order'			=> 'ASC',
	'tax_query'	=> array(
		array(
			'taxonomy'	=> 'category',
			'field'		=> 'slug',
			'terms'		=> 'washing'
		)
	)
]);
$terms_post = get_post(146);

$cats = get_terms([
	'taxonomy'	=> $query->taxonomy,
	'parent'	=> $query->term_id	
]);

$more_term = get_terms([
	'taxonomy'	=> 'product_cat',
	'parent'	=> 0,
	'hide_empty'=> false,
	'exclude'	=> array(15,35)
]);


$customTaxonomyTerms = wp_get_object_terms( $query->ID, 'product_cat', array('fields' => 'ids') );
$args = array(
    'post_type' => 'product',
    'post_status' => 'publish',
    'posts_per_page' => 10,
    'orderby' => 'rand',
    'post__not_in' => array ($query->ID),
    'tax_query' => array(
        array(
            'taxonomy' => 'product_cat',
            'field' => 'id',
            'terms' => $customTaxonomyTerms
        )
    )
);

//the query
$related = get_posts( $args );


?>
<div class="banner" style="background-image: url('<?php echo get_template_directory_uri().
'/assets/images/planchado-lavanderia_137573-984.webp';?>');">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>Laundary Service</h1>
				<p>Get all your Regular Wear items & Linens-Washed, Dried & Steam Ironed / Neatly folded and stacked in a weatherproof box.</p>
			</div>
		</div>
	</div>
</div>

<section class="service-two">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h1>our process</h1>
			</div>
			<?php
			global $counter; 
			foreach($serv as $key => $post){
				$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
				$counter ++ ;
			?>
			<div class="col-lg-4">
				<div class="wrapper">
					<h4>0<?php echo $counter;?></h4>
					<div class="img-wrap">
						<img src="<?php echo $image[0];?>" class="img-responsive">
					</div>
					<p><?php echo $post->post_title;?></p>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>


<?php /**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
//do_action( 'woocommerce_before_main_content' );

?>
<header class="woocommerce-products-header">
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	//do_action( 'woocommerce_archive_description' );
	?>
</header>
<?php
if ( woocommerce_product_loop() ) {

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	//do_action( 'woocommerce_before_shop_loop' );

	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();

	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
//do_action( 'woocommerce_sidebar' ); ?>

<section class="service-three">
	<div class="container">
		<div class="row">
			<div class="col-lg-5">
				<h1>Pricing</h1>
				<div class="panel-group" id="accordion">
					<?php 
					foreach($cats as $terms){
						$arg = get_posts([
							'post_type'		=> 'product',
							'post_status'	=> 'publish',
							'tax_query'	=> array(
								array(
									'taxonomy'	=> $terms->taxonomy,
									'field'		=> 'id',
									'terms'		=> $terms->term_id
								)
							)

						]);

					?>
				  <div class="panel panel-default">
				    <div class="panel-heading">
				      <h4 class="panel-title">
				        <a data-toggle="collapse" data-parent="#accordion" href="#<?php echo $terms->term_id;?>">
				        <?php echo $terms->name;?></a>
				      </h4>
				    </div>
				    <div id="<?php echo $terms->term_id;?>" class="panel-collapse collapse in">
				      <div class="panel-body">
				      	<ul class="price_ul">
				      		<?php 
				      		foreach($arg as $posts){
				      			$product = new WC_Product($posts->ID);
				      		?>
						  <li><p><?php echo $posts->post_title;?> </p><p><?php echo $product->get_regular_price();?> </p></li>
						<?php } ?>
						</ul>
				      </div>
				    </div>
				  </div>
					<?php } ?>
				</div>
			</div>
			<div class="col-lg-7">
				
				<?php 
					if($query->slug == 'men'){
				?>
				<h1><?php echo $terms_post->post_title;?></h1>
					<?php echo $terms_post->post_content;?>
				<?php } ?>	 
			</div>
		</div>
	</div>
</section>

<section class="sec-one">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h4>our services</h4>
				<h1>What we do</h1>
				<ul>
				<?php 
				foreach($more_term as $terms){
					$thumbnail_id = get_term_meta( $terms->term_id, 'thumbnail_id', true ); 
					// get the image URL
					$image = wp_get_attachment_url( $thumbnail_id ); 

				?>
				<li>
					<div class="wrapper">
						<img src="<?php echo $image;?>" class="img-responsive">
						<h3><?php echo $terms->name;?></h3>
						<p><?php echo $terms->description;?></p>
						<a href="<?php echo get_term_link($terms->term_id);?>">
							<i class="fa fa-angle-right"></i>
						</a>
					</div>
				</li>
				<?php } ?>
			</ul>	
			</div>
		</div>
	</div>
</section>

<?php get_footer( 'custom' );
